///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK EditBackupOptionsDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND BackupName_hWnd        = NULL;
    static HWND BackupDescription_hWnd = NULL;
    static HWND BackupFileName_hWnd    = NULL;

	if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
	{
		EditBackupOptionsDialog_hWnd = xHandle;

		SendMessage(EditBackupOptionsDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)"Backup Options");
		SendMessage(EditBackupOptionsDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(100)));

        BackupName_hWnd        = GetDlgItem(EditBackupOptionsDialog_hWnd, 1000);
        BackupDescription_hWnd = GetDlgItem(EditBackupOptionsDialog_hWnd, 1001);
        BackupFileName_hWnd    = GetDlgItem(EditBackupOptionsDialog_hWnd, 1002);

        Set_Text(BackupName_hWnd, BT[ESD.EditItem].Name);
        Set_Text(BackupDescription_hWnd, BT[ESD.EditItem].Description);
        Set_Text(BackupFileName_hWnd, BT[ESD.EditItem].Filename);

 		CenterWindow(EditBackupOptionsDialog_hWnd);

		return 0;
	}

	if(xMessage == WM_COMMAND) // Received A Message
	{
		if(wParam == 100) //- Ok (Dialog Command)
		{
            char *xBackupName        = Get_Text(BackupName_hWnd);
            char *xBackupDescription = Get_Text(BackupDescription_hWnd);
            char *xBackupFileName    = Get_Text(BackupFileName_hWnd);

            if( strlen(xBackupName) < 1)
            {
                MessageBox(EditBackupOptionsDialog_hWnd, "You must specify a backup name.", TitleCaption, 0);
                return 0;
            }

            if( strlen(xBackupDescription) < 1)
            {
                MessageBox(EditBackupOptionsDialog_hWnd, "You must specify a backup description,", TitleCaption, 0);
                return 0;
            }

            if( strlen(xBackupFileName) < 1)
            {
                MessageBox(EditBackupOptionsDialog_hWnd, "You must specify a backup file name.", TitleCaption, 0);
                return 0;
            }

            BOD.BackupName        = xBackupName;
            BOD.BackupDescription = xBackupDescription;
            BOD.BackupFileName    = xBackupFileName;

            BOD.Complete = TRUE;

			EndDialog(EditBackupOptionsDialog_hWnd,0);

			return 0;
		}

		if(wParam==102) //- Browse (Dialog Command)
		{
            char FileName[256];
            char *DefaultExtension = NULL;
            char *Filters = "SQL-Backup-File\0*.sbf\0\0";

            DWORD DialogType = OFD;
            DWORD Flags   = OFN_EXPLORER + OFN_LONGNAMES + OFN_PATHMUSTEXIST;

            Get_TextEx(BackupFileName_hWnd, FileName, 256);

            if(OSFileDialog(EditBackupOptionsDialog_hWnd, FileName, DefaultExtension, TitleCaption, Filters, Get_CurrentDirectory(), SFD, Flags))
                Set_Text(BackupFileName_hWnd, FileName);

			return 0;
		}

		if(wParam==101) //- Cancel (Dialog Command)
		{
			EndDialog(EditBackupOptionsDialog_hWnd,0);
			return 0;
		}

		return 0;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

